/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.economy.transactions.composer;

import com.google.common.base.Suppliers;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigDecimal;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.transactions.EconomyTransferTransaction;
import net.impactdev.impactor.api.economy.transactions.details.EconomyResultType;
import net.impactdev.impactor.api.utility.builders.Builder;
import net.impactdev.impactor.api.utility.builders.Required;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface TransferComposer
extends Builder<EconomyTransferTransaction> {
    @Required
    @Contract(value="_ -> this")
    @CanIgnoreReturnValue
    public TransferComposer from(@NotNull Account var1);

    @Required
    @Contract(value="_ -> this")
    @CanIgnoreReturnValue
    public TransferComposer to(@NotNull Account var1);

    @Required
    @Contract(value="_ -> this")
    @CanIgnoreReturnValue
    public TransferComposer amount(@NotNull BigDecimal var1);

    @Contract(value="_,_ -> this")
    @CanIgnoreReturnValue
    default public TransferComposer message(@NotNull EconomyResultType type, @NotNull Component message) {
        return this.message(type, (Supplier<Component>)Suppliers.memoize(() -> message));
    }

    @Contract(value="_,_ -> this")
    @CanIgnoreReturnValue
    public TransferComposer message(@NotNull EconomyResultType var1, @NotNull @NotNull Supplier<@NotNull Component> var2);

    @Override
    public EconomyTransferTransaction build();

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="6.0.0")
    default public @NotNull CompletableFuture<@NotNull EconomyTransferTransaction> send() {
        return CompletableFuture.completedFuture(this.build());
    }
}

